<?php 
    // Including db_connect to prevent errors, but data below is static
    include 'db_connect.php'; 
    include 'header.php'; 
?>

<section class="page-hero" style="height: 40vh; background: linear-gradient(rgba(102, 0, 0, 0.6), rgba(102, 0, 0, 0.6)), url('images/court-pillars.jpg') no-repeat center center/cover;">
    <div class="container">
        <h1>News & Notices</h1>
        <p>Official announcements, practice directions, and tender notices.</p>
    </div>
</section>

<section class="content-section reveal" style="padding: 80px 8%; background-color: #f9f9f9;">
    
    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(320px, 1fr)); gap: 30px;">
        
        <div class="news-item-card" style="background: #ffffff; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color); display: flex; flex-direction: column; justify-content: space-between;">
            <div style="padding-bottom: 15px; border-bottom: 1px solid #eee; margin-bottom: 15px;">
                <div class="news-meta" style="display: flex; gap: 15px; font-size: 0.8rem; color: #888; margin-bottom: 10px;">
                    <span><i class="far fa-calendar-alt" style="color: var(--gold-accent);"></i> Feb 01, 2026</span>
                    <span style="color: var(--primary-color); font-weight: bold;">PRACTICE DIRECTION</span>
                </div>
                <h3 class="news-title" style="font-size: 1.3rem; margin-bottom: 10px; color: var(--primary-color);">Filing of Written Submissions in Land Appeals</h3>
                <p style="color: #666; font-size: 0.95rem; line-height: 1.6;">New guidelines regarding the formatting, page limits, and binding for written submissions in Land Acquisition cases effective from March 1st.</p>
            </div>
            <a href="#" class="btn-black" style="background: #333; color: white; padding: 10px 20px; border-radius: 4px; font-size: 0.85rem; display: inline-block; text-align: center; text-decoration: none; align-self: flex-start;">Download PDF <i class="fas fa-download" style="margin-left: 5px;"></i></a>
        </div>

        <div class="news-item-card" style="background: #ffffff; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color); display: flex; flex-direction: column; justify-content: space-between;">
            <div style="padding-bottom: 15px; border-bottom: 1px solid #eee; margin-bottom: 15px;">
                <div class="news-meta" style="display: flex; gap: 15px; font-size: 0.8rem; color: #888; margin-bottom: 10px;">
                    <span><i class="far fa-calendar-alt" style="color: var(--gold-accent);"></i> Jan 25, 2026</span>
                    <span style="color: var(--primary-color); font-weight: bold;">TENDER NOTICE</span>
                </div>
                <h3 class="news-title" style="font-size: 1.3rem; margin-bottom: 10px; color: var(--primary-color);">Procurement of IT Equipment</h3>
                <p style="color: #666; font-size: 0.95rem; line-height: 1.6;">Call for bids for the supply of computers, printers, and scanners for the new court registry complex digitization project.</p>
            </div>
            <a href="#" class="btn-black" style="background: #333; color: white; padding: 10px 20px; border-radius: 4px; font-size: 0.85rem; display: inline-block; text-align: center; text-decoration: none; align-self: flex-start;">View Details <i class="fas fa-arrow-right" style="margin-left: 5px;"></i></a>
        </div>

        <div class="news-item-card" style="background: #ffffff; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color); display: flex; flex-direction: column; justify-content: space-between;">
            <div style="padding-bottom: 15px; border-bottom: 1px solid #eee; margin-bottom: 15px;">
                <div class="news-meta" style="display: flex; gap: 15px; font-size: 0.8rem; color: #888; margin-bottom: 10px;">
                    <span><i class="far fa-calendar-alt" style="color: var(--gold-accent);"></i> Jan 10, 2026</span>
                    <span style="color: var(--primary-color); font-weight: bold;">COURT HOLIDAY</span>
                </div>
                <h3 class="news-title" style="font-size: 1.3rem; margin-bottom: 10px; color: var(--primary-color);">Thai Pongal Court Holiday</h3>
                <p style="color: #666; font-size: 0.95rem; line-height: 1.6;">The Civil Appellate High Court will not sit on January 14th due to the Thai Pongal festival. Registry will remain closed.</p>
            </div>
            <a href="#" class="btn-black" style="background: #333; color: white; padding: 10px 20px; border-radius: 4px; font-size: 0.85rem; display: inline-block; text-align: center; text-decoration: none; align-self: flex-start;">Read Notice <i class="fas fa-file-alt" style="margin-left: 5px;"></i></a>
        </div>

        <div class="news-item-card" style="background: #ffffff; padding: 30px; border-radius: 5px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); border-top: 4px solid var(--primary-color); display: flex; flex-direction: column; justify-content: space-between;">
            <div style="padding-bottom: 15px; border-bottom: 1px solid #eee; margin-bottom: 15px;">
                <div class="news-meta" style="display: flex; gap: 15px; font-size: 0.8rem; color: #888; margin-bottom: 10px;">
                    <span><i class="far fa-calendar-alt" style="color: var(--gold-accent);"></i> Dec 20, 2025</span>
                    <span style="color: var(--primary-color); font-weight: bold;">VACANCY</span>
                </div>
                <h3 class="news-title" style="font-size: 1.3rem; margin-bottom: 10px; color: var(--primary-color);">Post of Management Assistant</h3>
                <p style="color: #666; font-size: 0.95rem; line-height: 1.6;">Applications are invited from qualified citizens for the post of Management Assistant (Grade III) in the High Court Registry.</p>
            </div>
            <a href="#" class="btn-black" style="background: #333; color: white; padding: 10px 20px; border-radius: 4px; font-size: 0.85rem; display: inline-block; text-align: center; text-decoration: none; align-self: flex-start;">Apply Now <i class="fas fa-user-plus" style="margin-left: 5px;"></i></a>
        </div>

    </div>

</section>

<script>
    window.addEventListener('scroll', function() {
        var reveals = document.querySelectorAll('.reveal');
        for(var i = 0; i < reveals.length; i++){
            var windowheight = window.innerHeight;
            var revealtop = reveals[i].getBoundingClientRect().top;
            var revealpoint = 150;
            if(revealtop < windowheight - revealpoint){
                reveals[i].classList.add('active');
            }
        }
    });
</script>

<?php include 'footer.php'; ?>